
IF EXISTS ( SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_CLI_BLOQUEIA_CLIENTE_ANONIMIZADO' )
BEGIN
	DROP TRIGGER TRG_RC_CLI_BLOQUEIA_CLIENTE_ANONIMIZADO
END
go
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081901
'Job.................:  
'Nome................: TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO 
'Objetivo............: Tratamento para nao alteracao do cliente Anonimizado
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 30/07/2021
'Alterado por........: 
'Criado por..........: Marcos Barros 
'=======================================================================================
*/
CREATE TRIGGER TRG_RC_CLI_BLOQUEIA_CLIENTE_ANONIMIZADO ON RC_CLI FOR UPDATE AS
	DECLARE @CD_CLI INT
	 IF UPDATE (UUID)
	BEGIN
		RETURN;
	END
	SET @CD_CLI = ISNULL((SELECT top 1 CD_CLI FROM inserted),0);

	IF EXISTS (SELECT 
					1 
			   FROM 
					LGPD_LOG_PROCESSAMENTO 
				WHERE
					CD_PESSOA = @CD_CLI
					AND TP_PROC = 0)
	  begin
		RAISERROR ('ALTERACAO NO PERMITIDA, CADASTRO DE CLIENTE ANONIMIZADO!',16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	  end
GO 